package com.ElyStudio.leGaou.activities;

import androidx.core.content.ContextCompat;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.databinding.ActivityGameWebViewScreenBinding;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.Constants;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;

public class GameWebViewScreen extends AppCompat {

    ActivityGameWebViewScreenBinding binding;
    String gameUrl,gameName;
    public static final String TAG = "GAME_WEB_VIEW_SCREEN";
    BottomSheetDialog exitBottomSheet,noInternetBottomSheet,errorOccurredBottomSheet;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityGameWebViewScreenBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        setupGameWebView();

    }
    @SuppressLint("SetJavaScriptEnabled")
    private void setupGameWebView(){

        gameUrl = getIntent().getStringExtra(Constants.gameUrl);
        gameName = getIntent().getStringExtra(Constants.gameName);

        WebView webView = binding.gameWebView;
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        webView.setWebChromeClient(new WebChromeClient());

        webView.setWebViewClient(new WebViewClient(){
            @Override
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                Log.d(TAG,"WebView error = "+error.toString());
                showErrorOccurredBottomSheet();
            }

            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
            }
        });

        if(CheckInternetConnection.isInternetConnected(GameWebViewScreen.this))
        {
            webView.loadUrl(gameUrl);
        }
        else
        {
            showNoInternetBottomSheet();
        }
    }
    public void showExitBottomSheet(){

        exitBottomSheet = new BottomSheetDialog(GameWebViewScreen.this);
        View view = LayoutInflater.from(GameWebViewScreen.this).inflate(R.layout.exit_bottomsheet_layout,binding.getRoot().findViewById(R.id.exitLayout),false);
        exitBottomSheet.setContentView(view);
        Button yesBtn = view.findViewById(R.id.yesBtn);
        Button noBtn = view.findViewById(R.id.noBtn);
        TextView exitTitle = view.findViewById(R.id.exitBottomSheetTitle);
        TextView exitSubText = view.findViewById(R.id.exitSubText);


        exitTitle.setText(String.format(getResources().getString(R.string.exit_game_warning),gameName));
        exitSubText.setVisibility(View.GONE);

        yesBtn.setText(getResources().getString(R.string.exit_game));
        noBtn.setText(getResources().getString(R.string.continue_game));

        noBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                exitBottomSheet.cancel();
            }
        });

        yesBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(GameWebViewScreen.this, MainActivity.class));
                finish();
                exitBottomSheet.cancel();
            }
        });

        if(!GameWebViewScreen.this.isFinishing())
        {
            exitBottomSheet.show();
        }

    }

    @Override
    public void onBackPressed() {
        if(binding.gameWebView.canGoBack())
        {
            binding.gameWebView.goBack();
        }
        else
        {
            showExitBottomSheet();
        }
    }
    public void showNoInternetBottomSheet(){

        noInternetBottomSheet = new BottomSheetDialog(GameWebViewScreen.this);
        View view = LayoutInflater.from(GameWebViewScreen.this).inflate(R.layout.error_occurred_bottom_sheet,findViewById(R.id.errorOccurredBottomSheetLayout),false);
        noInternetBottomSheet.setContentView(view);

        Button contactSupportBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetSecondaryButton);
        Button tryAgainBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetPrimaryButton);
        ImageView bottomSheetIllustration = noInternetBottomSheet.findViewById(R.id.bottomSheetIllustraton);
        TextView bottomSheetTitle = noInternetBottomSheet.findViewById(R.id.bottomSheetTitle);
        noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = noInternetBottomSheet.findViewById(R.id.bottomSheetSubText);
        contactSupportBtn.setVisibility(View.GONE);

        tryAgainBtn.setText(getResources().getString(R.string.try_again));

        tryAgainBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(CheckInternetConnection.isInternetConnected(GameWebViewScreen.this))
                {
                    noInternetBottomSheet.cancel();
                    binding.gameWebView.loadUrl(gameUrl);
                }
                else
                {
                    QuizzeSnackBar.showSnackBar(GameWebViewScreen.this,view,getResources().getString(R.string.no_internet),getResources().getColor(R.color.error));
                }
            }
        });

        bottomSheetTitle.setText(getResources().getString(R.string.no_internet));
        bottomSheetSubText.setText(getResources().getString(R.string.no_internet_sub_text));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable(GameWebViewScreen.this,R.drawable.no_conection_illustration));

        if(!GameWebViewScreen.this.isFinishing())
        {
            noInternetBottomSheet.show();
        }

    }

    public void showErrorOccurredBottomSheet(){

        errorOccurredBottomSheet = new BottomSheetDialog(GameWebViewScreen.this);
        View view = LayoutInflater.from(GameWebViewScreen.this).inflate(R.layout.error_occurred_bottom_sheet,findViewById(R.id.errorOccurredBottomSheetLayout),false);
        errorOccurredBottomSheet.setContentView(view);
        errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = errorOccurredBottomSheet.findViewById(R.id.bottomSheetSecondaryButton);
        Button tryAgainBtn = errorOccurredBottomSheet.findViewById(R.id.bottomSheetPrimaryButton);
        ImageView bottomSheetIllustration = errorOccurredBottomSheet.findViewById(R.id.bottomSheetIllustraton);
        TextView bottomSheetTitle = errorOccurredBottomSheet.findViewById(R.id.bottomSheetTitle);
        TextView bottomSheetSubText = errorOccurredBottomSheet.findViewById(R.id.bottomSheetSubText);

        bottomSheetTitle.setText(getResources().getString(R.string.some_error_occurred));
        bottomSheetSubText.setText(getResources().getString(R.string.error_subtext));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable(GameWebViewScreen.this,R.drawable.error_illustration));
        contactSupportBtn.setText(getResources().getString(R.string.contact_support));
        tryAgainBtn.setText(getResources().getString(R.string.try_again));

        contactSupportBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(GameWebViewScreen.this, SupportScreen.class));
            }
        });

        tryAgainBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                errorOccurredBottomSheet.cancel();
                binding.gameWebView.loadUrl(gameUrl);
            }
        });

        if(!GameWebViewScreen.this.isFinishing())
        {
            errorOccurredBottomSheet.show();
        }
    }
}